<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('accounting::lang.add', 1), false); ?> <?php echo e(trans_choice('accounting::general.journal', 1), false); ?>

    <?php echo e(trans_choice('accounting::lang.entry', 1), false); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('accounting::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <?php $__env->startComponent('accounting::components.section_header'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(trans_choice('accounting::general.accounting', 1), false); ?>

        <?php $__env->endSlot(); ?>
        <?php $__env->slot('subtitle'); ?>
            <?php echo e(trans_choice('accounting::lang.add', 1), false); ?> <?php echo e(trans_choice('accounting::general.journal', 1), false); ?>

            <?php echo e(trans_choice('accounting::lang.entry', 1), false); ?>

        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <!-- Main content -->
    <section class="content no-print" id="vue-app">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.view')): ?>
            <div class="row">

                <?php $__env->startComponent('accounting::components.box'); ?>
                    <?php $__env->slot('body'); ?>
                        <section class="content">
                            <form method="post" action="<?php echo e(url('accounting/journal_entry/store'), false); ?>">
                                <?php echo e(csrf_field(), false); ?>

                                <div class="card card-bordered card-preview">
                                    <div class="card-body">
                                        <div class="row gy-4">

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="location_id"
                                                        class="control-label"><?php echo e(trans_choice('accounting::lang.business_location', 1), false); ?></label>
                                                    <select class="form-control <?php if ($errors->has('location_id')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('location_id'); ?> is-invalid <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>" name="location_id"
                                                        id="location_id" v-model="location_id" required>
                                                        <option value="" disabled selected><?php echo e(trans_choice('accounting::lang.select', 1), false); ?>

                                                        </option>
                                                        <?php $__currentLoopData = $business_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($key->id, false); ?>"><?php echo e($key->name, false); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <?php if ($errors->has('location_id')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('location_id'); ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($message, false); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="currency_id"
                                                        class="control-label"><?php echo e(trans_choice('accounting::lang.currency', 1), false); ?></label>
                                                    <v-select label="currency" :options="currencies" :reduce="currency => currency.id"
                                                        v-model="currency_id">
                                                        <template #search="{attributes, events}">
                                                            <input autocomplete="off" class="vs__search <?php if ($errors->has('currency_id')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('currency_id'); ?> is-invalid <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>"
                                                                :required="!currency_id" v-bind="attributes" v-on="events" />
                                                        </template>
                                                    </v-select>
                                                    <input type="hidden" name="currency_id" v-model="currency_id">
                                                    <?php if ($errors->has('currency_id')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('currency_id'); ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($message, false); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="date" class="control-label"><?php echo e(trans_choice('accounting::lang.date', 1), false); ?></label>
                                                    <input type="text" v-model="date" class="form-control datepicker <?php if ($errors->has('date')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('date'); ?> is-invalid <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>"
                                                        name="date" required>
                                                    <?php if ($errors->has('date')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('date'); ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($message, false); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label for="payment_type_id" class="control-label"><?php echo e(trans_choice('accounting::lang.payment', 1), false); ?>

                                                        <?php echo e(trans_choice('accounting::lang.type', 1), false); ?></label>
                                                    <select class="form-control" name="payment_type_id" id="payment_type_id">
                                                        <?php $__currentLoopData = $payment_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($payment_type->id, false); ?>"><?php echo e($payment_type->name, false); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <?php if ($errors->has('payment_type_id')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('payment_type_id'); ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($message, false); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                                                </div>
                                            </div>

                                            

                                            <div class="col-md-12">
                                                <div class="table-responsive">
                                                    <table class="table table-bordered">
                                                        <thead>
                                                            <th><?php echo e(trans('accounting::lang.debit'), false); ?></th>
                                                            <th><?php echo e(trans('accounting::lang.credit'), false); ?></th>
                                                            <th><?php echo e(trans('accounting::lang.amount'), false); ?></th>
                                                            <th><?php echo e(trans('accounting::lang.description'), false); ?></th>
                                                            <th><?php echo e(trans_choice('accounting::lang.action', 1), false); ?></th>
                                                        </thead>
                                                        <tbody>
                                                            <tr v-for="(data, index) in journal_entry_data" :id="index">
                                                                <td>
                                                                    <div class="form-group">
                                                                        <label for="debit"
                                                                            class="control-label"><?php echo e(trans_choice('accounting::general.chart_of_account', 1), false); ?></label>
                                                                        <v-select label="name_with_subtype" :options="chart_of_accounts"
                                                                            :reduce="account => account.id" v-model="journal_entry_data[index].debit">
                                                                            <template #search="{attributes, events}">
                                                                                <input autocomplete="off"
                                                                                    class="vs__search <?php if ($errors->has('debit')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('debit'); ?> is-invalid <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>"
                                                                                    v-bind="attributes" v-bind:required="!journal_entry_data[index].debit"
                                                                                    v-on="events" />
                                                                            </template>
                                                                        </v-select>
                                                                        <input type="hidden" :name="`journal_entry_data[${index}][debit]`"
                                                                            v-model="journal_entry_data[index].debit">
                                                                        <?php if ($errors->has('debit')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('debit'); ?>
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong><?php echo e($message, false); ?></strong>
                                                                            </span>
                                                                        <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group">
                                                                        <label for="credit"
                                                                            class="control-label"><?php echo e(trans_choice('accounting::general.chart_of_account', 1), false); ?></label>
                                                                        <v-select label="name_with_subtype" :options="chart_of_accounts"
                                                                            :reduce="account => account.id" v-model="journal_entry_data[index].credit">
                                                                            <template #search="{attributes, events}">
                                                                                <input autocomplete="off"
                                                                                    class="vs__search <?php if ($errors->has('credit')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('credit'); ?> is-invalid <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>"
                                                                                    v-bind="attributes" v-bind:required="!journal_entry_data[index].credit"
                                                                                    v-on="events" />
                                                                            </template>
                                                                        </v-select>
                                                                        <input type="hidden" :name="`journal_entry_data[${index}][credit]`"
                                                                            v-model="journal_entry_data[index].credit">
                                                                        <?php if ($errors->has('credit')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('credit'); ?>
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong><?php echo e($message, false); ?></strong>
                                                                            </span>
                                                                        <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group">
                                                                        <label for="amount"
                                                                            class="control-label"><?php echo e(trans_choice('accounting::lang.amount', 1), false); ?></label>
                                                                        <input type="number" :name="`journal_entry_data[${index}][amount]`"
                                                                            v-model="journal_entry_data[index].amount" id="amount"
                                                                            class="form-control numeric <?php if ($errors->has('amount')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('amount'); ?> is-invalid <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>" required>
                                                                    </div>
                                                                    <?php if ($errors->has('amount')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('amount'); ?>
                                                                        <span class="invalid-feedback" role="alert">
                                                                            <strong><?php echo e($message, false); ?></strong>
                                                                        </span>
                                                                    <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group">
                                                                        <label for="notes"
                                                                            class="control-label"><?php echo e(trans_choice('accounting::lang.note', 2), false); ?></label>
                                                                        <textarea type="text" :name="`journal_entry_data[${index}][notes]`" v-model="journal_entry_data[index].notes"
                                                                            class="form-control <?php if ($errors->has('notes')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('notes'); ?> is-invalid <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>">                                                                                                         </textarea>
                                                                        <?php if ($errors->has('notes')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('notes'); ?>
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong><?php echo e($message, false); ?></strong>
                                                                            </span>
                                                                        <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="btn-group">
                                                                        <div v-if="journal_entry_data.length > 1" class="btn btn-xs btn-danger"
                                                                            @click="remove_row(index)">
                                                                            <i class="fa fa-times"></i>
                                                                        </div>
                                                                        <div v-if="index == journal_entry_data.length - 1" class="btn btn-xs btn-primary"
                                                                            @click="add_row">
                                                                            <i class="fa fa-plus"></i>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                            <tr class="bg-grand-total">
                                                                <td colspan="2">
                                                                    <?php echo e(trans('sale.total'), false); ?>

                                                                </td>
                                                                <td>{{ number_format(amount_total) }}</td>
                                                                <td colspan="2"></td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                            
                                        </div>
                                    </div>

                                    <div class="card-footer btn-group float-right">
                                        <a href="<?php echo e(url('accounting/journal_entry'), false); ?>"
                                            class="btn btn-danger confirm"><?php echo e(trans_choice('accounting::lang.cancel', 1), false); ?></a>
                                        <button type="submit" class="btn btn-primary"><?php echo e(trans_choice('accounting::lang.save', 1), false); ?></button>
                                    </div>
                                </div><!-- .card-preview -->
                            </form>
                        </section>
                    <?php $__env->endSlot(); ?>
                <?php echo $__env->renderComponent(); ?>

            </div>
        <?php endif; ?>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <script>
        var app = new Vue({
            el: "#vue-app",
            data: {
                location_id: "<?php echo e(old('location_id'), false); ?>",
                currency_id: parseInt("<?php echo e(old('currency_id'), false); ?>"),
                reference: "<?php echo e(old('reference'), false); ?>",
                date: "<?php echo e(old('date', date('Y-m-d')), false); ?>",
                payment_type_id: "<?php echo e(old('payment_type_id'), false); ?>",
                receipt: "<?php echo e(old('receipt'), false); ?>",
                notes: "<?php echo e(old('notes'), false); ?>",
                currencies: <?php echo json_encode($currencies); ?>,
                chart_of_accounts: <?php echo json_encode($chart_of_accounts); ?>,
                journal_entry_data: <?php echo json_encode(old('journal_entry_data', []), JSON_NUMERIC_CHECK); ?>

            },

            mounted() {
                this.add_default_row();
            },

            computed: {
                amount_total() {
                    let sum = 0;
                    for (const el of this.journal_entry_data) {
                        const amount = el.amount == '' || isNaN(el.amount) ? 0 : parseInt(el.amount);
                        sum += amount;
                    }
                    return sum;
                }
            },

            methods: {
                add_default_row() {
                    if (this.journal_entry_data.length == 0) {
                        this.add_row();
                    }
                },

                add_row() {
                    this.journal_entry_data.push({
                        debit: '',
                        credit: '',
                        amount: '',
                        notes: '',
                    });
                },

                remove_row(index) {
                    this.journal_entry_data.splice(index, 1);
                },

                number_format(number) {
                    return new Intl.NumberFormat().format(number);
                }
            }
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/welz1763/public_html/welcomp.my.id/Modules/Accounting/Providers/../Resources/views/journal_entry/create.blade.php ENDPATH**/ ?>