<div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
        <?php echo Form::open(['url' => action('\Modules\Crm\Http\Controllers\ScheduleController@store'), 'method' => 'post', 'id' => 'add_schedule' ]); ?>

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="myModalLabel">
                    <?php echo app('translator')->getFromJson('crm::lang.add_schedule'); ?>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <input type="hidden" name="schedule_for" value="<?php echo e($schedule_for, false); ?>" id="schedule_for">
                    <div class="col-md-8">
                       <div class="form-group">
                            <?php echo Form::label('title', __('crm::lang.title') . ':*' ); ?>

                            <?php echo Form::text('title', null, ['class' => 'form-control', 'required' ]); ?>

                       </div>
                    </div>
                    <div class="col-md-4">
                       <div class="form-group">
                            <?php echo Form::label('contact_id', __('contact.customer') . '/' . __('crm::lang.lead') .':*'); ?>

                            <?php echo Form::select('contact_id', $customers, $contact_id, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'required', 'style' => 'width: 100%;']);; ?>

                       </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                       <div class="form-group">
                            <?php echo Form::label('status', __('sale.status') .':'); ?>

                            <?php echo Form::select('status', $statuses, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'style' => 'width: 100%;', 'id' => 'follow_up_create_status']);; ?>

                       </div>
                    </div>
                    <div class="col-md-4">
                       <div class="form-group">
                            <?php echo Form::label('start_datetime', __('crm::lang.start_datetime') . ':*' ); ?>

                            <?php echo Form::text('start_datetime', null, ['class' => 'form-control datetimepicker', 'required', 'readonly']); ?>

                       </div>
                    </div>
                    <div class="col-md-4">
                       <div class="form-group">
                            <?php echo Form::label('end_datetime', __('crm::lang.end_datetime') . ':*' ); ?>

                            <?php echo Form::text('end_datetime', null, ['class' => 'form-control datetimepicker', 'required', 'readonly']); ?>

                       </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <?php echo Form::label('description', __('crm::lang.description') . ':'); ?>

                            <?php echo Form::textarea('description', null, ['class' => 'form-control ', 'id' => 'description']);; ?>

                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <?php echo Form::label('schedule_type', __('crm::lang.schedule_type') .':*'); ?>

                            <?php echo Form::select('schedule_type', $follow_up_types, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'required', 'style' => 'width: 100%;']);; ?>

                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <?php echo Form::label('user_id', __('crm::lang.assgined') .':*'); ?>

                            <?php echo Form::select('user_id[]', $users, null, ['class' => 'form-control select2', 'multiple', 'required', 'style' => 'width: 100%;']);; ?>

                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>
                                <?php echo Form::checkbox('allow_notification', 1, false, ['class' => 'input-icheck', 'id' => 'allow_notification']);; ?>

                                <?php echo app('translator')->getFromJson('crm::lang.send_notification'); ?>
                            </label>
                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('crm::lang.send_schedule_notificatoion') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <div class="allow_notification_elements hide">
                        <div class="col-md-6">
                            <?php echo Form::label('notify_via', __('crm::lang.notify_via') .':*'); ?> 
                            <div class="form-group checkbox-inline">
                                <label>
                                    <?php echo Form::checkbox('notify_via[sms]', 1, false, ['class' => 'input-icheck']);; ?>

                                    <?php echo app('translator')->getFromJson('crm::lang.sms'); ?>
                                </label>
                            </div>
                            <div class="form-group checkbox-inline">
                                <label>
                                    <?php echo Form::checkbox('notify_via[mail]', 1, true, ['class' => 'input-icheck']);; ?>

                                    <?php echo app('translator')->getFromJson('business.email'); ?>
                                </label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <div class="multi-input">
                                    <?php echo Form::label('notify_before', __('crm::lang.notify_before') . ':*'); ?>

                                    <br/>
                                    <?php echo Form::number('notify_before', null, ['class' => 'form-control width-40 pull-left', 'placeholder' => __('crm::lang.notify_before'), 'required']);; ?>


                                    <?php echo Form::select('notify_type', $notify_type, '', ['class' => 'form-control width-60 pull-left']);; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">
                <?php echo app('translator')->getFromJson('messages.close'); ?>
                </button>
                <button type="submit" class="btn btn-primary">
                    <?php echo app('translator')->getFromJson('messages.save'); ?>
                </button>
            </div>
        <?php echo Form::close(); ?>

    </div>
</div><?php /**PATH /home/u9071760/public_html/Modules/Crm/Providers/../Resources/views/schedule/create.blade.php ENDPATH**/ ?>