<?php $__env->startSection('title', __('partners::lang.partners')); ?>
<?php $__env->startSection('content'); ?>
    <style>
        .table-striped th {
            background-color: #626161;
            color: #ffffff;
        }
    </style>

    <?php echo $__env->make('partners::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <section class="content-header">
        <h1><?php echo app('translator')->get('partners::lang.partners'); ?></h1>
    </section>

    <div style="margin:auto;max-width: 70%;">
        <div class="row">

            <div class="col-md-3">
                <div class="form-group">
                    <?php echo Form::label('capital', __('partners::lang.capital_approved')); ?>

                    <?php echo Form::text('capital', $business_data->capital, ['class' => 'form-control decimal', 'required', 'placeholder' => __('partners::lang.name')]); ?>

                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <?php echo Form::label('sharenumber', __('partners::lang.number_of_shares')); ?>

                    <?php echo Form::text('sharenumber', $business_data->sharenumber, ['class' => 'form-control', 'required', 'placeholder' => __('partners::lang.name')]); ?>

                </div>
            </div>

            <?php if(auth()->user()->can('partners.create')): ?>
                <div class="col-md-2" style="margin-top: 23px;">
                    <button class="btn btn-danger" onclick="savedata()"><?php echo app('translator')->get('messages.save'); ?></button>
                </div>
            <?php endif; ?>

        </div>

        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    <?php echo Form::label('capital_rem', __('partners::lang.remaining_approved_capital')); ?>

                    <?php echo Form::text('capital_rem', $business_data->capital - $totalcapital , ['class' => 'form-control decimal', 'readonly', 'placeholder' => __('partners::lang.name')]); ?>

                </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <?php echo Form::label('sharenumber_rem', __('partners::lang.remaining_number_of_shares')); ?>

                    <?php echo Form::text('sharenumber_rem', $business_data->sharenumber - $totalshare, ['class' => 'form-control', 'readonly', 'placeholder' => __('partners::lang.name')]); ?>

                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => '']); ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('assets.create')): ?>
                <?php $__env->slot('tool'); ?>
                    <div class="box-tools">
                        <?php if(auth()->user()->can('partners.create')): ?>
                            <button type="button" class="btn btn-block btn-primary btn-modal"
                                    data-href="<?php echo e(action('\Modules\Partners\Http\Controllers\PartnersController@create'), false); ?>"
                                    data-container=".brands_modal">
                                <i class="fa fa-plus"></i> <?php echo app('translator')->get('messages.add'); ?>
                            </button>
                        <?php endif; ?>
                    </div>
                <?php $__env->endSlot(); ?>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('assets.view')): ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="assete_table">
                        <thead>
                        <tr>
                            <th><?php echo app('translator')->get('partners::lang.name'); ?></th>
                            <th><?php echo app('translator')->get('partners::lang.address'); ?></th>
                            <th><?php echo app('translator')->get('partners::lang.phone_number'); ?></th>
                            <th><?php echo app('translator')->get('partners::lang.paid_capital_value'); ?></th>
                            <th><?php echo app('translator')->get('partners::lang.number_of_shares'); ?></th>
                            <th><?php echo app('translator')->get('partners::lang.credit_balance'); ?></th>
                            <th><?php echo app('translator')->get('partners::lang.debit_balance'); ?></th>
                            <th><?php echo app('translator')->get('messages.action'); ?></th>
                        </tr>
                        </thead>
                        <tbody id="datatable">
                        <?php $__currentLoopData = $partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr id="<?php echo e($partner->id, false); ?>">
                                <td><?php echo e($partner->name, false); ?></td>
                                <td><?php echo e($partner->address, false); ?></td>
                                <td><?php echo e($partner->mobile, false); ?></td>
                                <td><?php echo e($partner->capital, false); ?></td>
                                <td><?php echo e($partner->share, false); ?></td>
                                <td><?php if($partner->value < 0): ?> <?php echo e(abs($partner->value), false); ?> <?php endif; ?></td>
                                <td><?php if($partner->value > 0): ?> <?php echo e(abs($partner->value), false); ?> <?php endif; ?></td>
                                <td>
                                    <?php if(auth()->user()->can('partners.edit')): ?>
                                        <button onclick="assetedit(<?php echo e($partner->id, false); ?>)" class="btn btn-xs btn-primary btn-modal">
                                            <i class="glyphicon glyphicon-edit"></i> <?php echo app('translator')->get("messages.edit"); ?>
                                        </button>
                                        <button onclick="deleteasset(<?php echo e($partner->id, false); ?>)" class="btn btn-xs btn-danger delete_asset_button">
                                            <i class="glyphicon glyphicon-trash"></i> <?php echo app('translator')->get("messages.delete"); ?>
                                        </button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <tr id="0">
                            <th colspan="3"><?php echo app('translator')->get('messages.total'); ?>:</th>
                            <th><?php echo e($totalcapital, false); ?></th>
                            <th><?php echo e($totalshare, false); ?></th>
                            <th colspan="3"></th>
                        </tr>
                        </tbody>

                    </table>
                </div>
            <?php endif; ?>
        <?php echo $__env->renderComponent(); ?>
    </section>

    <div class="modal fade brands_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>
<?php $__env->stopSection(); ?>


<script type="text/javascript" src="<?php echo e(asset('Partners/Resources/assets/js/app.js'), false); ?>"></script>
<script>

    function assetedit(id) {
        $.ajax({
            url: '/partners/partners/'+id+'/edit',
            dataType: 'html',
            success: function(result) {
                $(".brands_modal").html(result)
                    .modal('show');
            },
        });
    }


    function  deleteasset(id) {
        swal({
            title: LANG.sure,
            text: 'Delete?',
            icon: 'warning',
            buttons: true,
            dangerMode: true,
        }).then(willDelete => {
            if (willDelete) {
                var href = '/partners/partners/'+id;
                var data = id;
                $.ajax({
                    method: 'DELETE',
                    url: href,
                    dataType: 'json',
                    data:{
                        data:data
                    },
                    success: function(result) {
                        if (result.success == true) {
                            toastr.success(result.msg);
                            var drow = document.getElementById(id);
                            drow.parentNode.removeChild(drow);
                        } else {
                            toastr.error(result.msg);
                        }
                    },
                });
            }
        });
    }


    function  savedata() {
        var capital=$('#capital').val();
        if(capital==''){
            toastr.error('عفوا برجاء إدخال رأس المال');;
            return true;
        }

        var sharenumber=$('#sharenumber').val();
        if(sharenumber==''){
            toastr.error('عفوا برجاء إدخال عدد الأسهم');
            return true;
        }

        swal({
            title: LANG.sure,
            text: 'هل تريد تعديل رأس مال الشركة وعدد الأسهم',
            icon: 'warning',
            buttons: true,
            dangerMode: true,
        }).then(willDelete => {
            if (willDelete) {
                var href = '/partners/savecapital';
               $.ajax({
                    method: 'POST',
                    url: href,
                    data:{
                        capital:capital
                        ,sharenumber:sharenumber
                    },
                    success: function(result) {
                        swal({
                            title: result.message,
                            icon: 'info',
                            });



                        if (result.success == true) {
                            toastr.success(result.msg);

                        } else {
                            toastr.error(result.msg);
                        }
                    },
                });
            }
        });
    }




</script>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/welz1763/public_html/welcomp.my.id/Modules/Partners/Providers/../Resources/views/partners/index.blade.php ENDPATH**/ ?>